unit top;

interface

uses HitCounter, productsDB, SysUtils, System.Web.UI, System.Drawing, System.Web.UI.WebControls;

type CSTop = Class(System.Web.UI.WebControls.Table)
   constructor Create;
 strict protected
    procedure OnLoad(E : EventArgs); override;
end;

implementation


function CellSpace : TableCell;
var 
    tc:TableCell;
    aImg:System.Web.UI.WebControls.Image;
begin
    tc:=TableCell.Create;
    aImg:=System.Web.UI.WebControls.Image.Create;
    aImg.ImageUrl:='gfx/c.gif';
    aImg.Width:= System.Web.UI.WebControls.Unit.Pixel(1);;
    with (tc) do
    begin
        BackColor:=Color.Fromargb(255,85,123,157);
        Width := System.Web.UI.WebControls.Unit.Pixel(1);
        Controls.Add(aImg);
    end;
    aImg.Free;

    //Result:=TableCell.Create;
    Result:=tc;

    tc.Free;
end;

procedure CSTop.OnLoad(E : EventArgs); 
var 
    tc  : TableCell;
    tr  : TableRow;
    tbl : Table;
    CSImage: System.Web.UI.WebControls.HyperLink;

    aRow :  System.Web.UI.WebControls.TableRow;
    aCell :  System.Web.UI.WebControls.TableCell;

    products : TproductsDB;
		hits : THitCounter;
begin
	inherited OnLoad(E);


    aRow := TableRow.Create;
    aCell := TableCell.Create;


    tr := TableRow.Create;
    tbl := Table.Create;

    with tbl do
    begin
        Rows.Add(tr);
        BackColor:=Color.White;
        Width:=System.Web.UI.WebControls.Unit.Percentage(100);
        BorderWidth := System.Web.UI.WebControls.Unit.Pixel(0);
        CellPadding:=0;
        CellSpacing:=0;
    end;


    CSImage:=System.Web.UI.WebControls.HyperLink.Create;
    with CSImage do
    begin
        ImageUrl := 'gfx/lcs.gif';
        NavigateURL:= 'webform1.aspx';
    end;

    // logo image cell
    tc:=TableCell.Create;
    with (tc) do
    begin
        //Width := System.Web.UI.WebControls.Unit.Pixel(310);
        Controls.Add(CSImage);
    end;
    tr.Cells.Add(tc);
    tc.Free;


    // cell veliki razmak cell
    tc:=TableCell.Create;
    with (tc) do
    begin
        //Width := System.Web.UI.WebControls.Unit.Percentage(30);
        Text:='Powered by ASP.NET and <a href="http://www.borland.com">Borland Delphi 8 Octane</a> (Delphi for .NET)';
        BackColor:=Color.White;
				CssClass:='smalltext';
    end;
    tr.Cells.Add(tc);
    tc.Free;


    // cell razmak cell
    tr.Cells.Add(CellSpace);

    //Nr users cell
		hits:=THitCounter.create;
    tc:=TableCell.Create;
    with (tc) do
    begin
        HorizontalAlign:=System.Web.UI.WebControls.HorizontalAlign.Left;
        CssClass:='smalltext';


				if not Self.Page.IsPostBack then
        begin
//          self.Page.Response.Write('not postback:' + Self.Page.Request.URL.AbsolutePath);
					Text := '&nbsp;Page hits today: ' +  IntToStr(hits.IncToday(Self.Page.Request.URL.AbsolutePath))
        end
				else
        begin
					Text := '&nbsp;Page hits today: ' +  IntToStr(hits.GetToday(Self.Page.Request.URL.AbsolutePath));
//          self.Page.Response.Write(' postback:' + Self.Page.Request.URL.AbsolutePath);
        end;
				Text := Text + '<br>' + '&nbsp;Site last week hits: ' + IntToStr(hits.GetThisWeek);
				Text := Text + '<br>' + '&nbsp;Site total hits: ' + IntToStr(hits.GetTotal);
        Width := System.Web.UI.WebControls.Unit.Pixel(140);
        tc.BackColor:=Color.White;
    end;
		hits.Free;
    tr.Cells.Add(tc);
    tc.Free;


    // cell razmak cell
    tr.Cells.Add(CellSpace);


    //datum i broj programa
    tc:=TableCell.Create;
    with (tc) do
    begin

        products := TproductsDB.Create;

//        ShortDateFormat :='dd.MM.yyyy';

        HorizontalAlign:=System.Web.UI.WebControls.HorizontalAlign.Center;
        CssClass:='smalltext';
//        Text:= DateToStr(Date)  + '<br> Baza sadr&#382;i <br>  <b>' + IntToStr(products.GetNumberOfProducts) + '</b> programa' ;
        Text:= 'We have <br>  <b>' + IntToStr(products.GetNumberOfProducts) + '</b> examples' ;
        Width := System.Web.UI.WebControls.Unit.Pixel(60);
        tc.BackColor:=Color.White;
    end;
    tr.Cells.Add(tc);
    tc.Free;


    // cell razmak cell
    tr.Cells.Add(CellSpace);

    //o crosoft
    tc:=TableCell.Create;
    with (tc) do
    begin
        Width := System.Web.UI.WebControls.Unit.Pixel(65);
        HorizontalAlign:=System.Web.UI.WebControls.HorizontalAlign.Center;
        CssClass:='smalltext';
        Controls.Add(HyperLink.Create);
        with (Controls[0] as HyperLink) do
        begin
            Text:='About';
            NavigateUrl:='webform2.aspx';
        end;
        BackColor:=Color.White;
        Wrap:=False;
    end;
    tr.Cells.Add(tc);
    tc.Free;

    // cell razmak cell
//    tr.Cells.Add(CellSpace);

    with Self do begin
        BackColor:=Color.Fromargb(255,85,123,157);
        Width:=System.Web.UI.WebControls.Unit.Percentage(100);
        BorderWidth := System.Web.UI.WebControls.Unit.Pixel(0);

        CellPadding:=5;
        CellSpacing:=0;

        aRow.Cells.Add(aCell);

        Rows.Add(aRow);

        //add table as svime ostalim
        aCell.Controls.Add(tbl);
        

    end;

end; //onload

constructor CSTop.Create; 
begin
    inherited create;
end; //create;

end.
